/**
 * Simple Site Sync - Developer Tools JavaScript
 */
jQuery(document).ready(function($) {
    
    // リリース作成ボタン
    $('#sss-create-release').on('click', function() {
        var $btn = $(this);
        var $status = $('#sss-release-status');
        
        if (!confirm('新しいリリースを作成します。\n\n現在のプラグインコードがZIP化され、info.jsonが更新されます。\nよろしいですか？')) {
            return;
        }
        
        $btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin" style="margin-top: 5px;"></span> リリース作成中...');
        $status.html('<div style="padding: 15px; background: #f0f6fc; border-left: 4px solid #0073aa; margin-top: 15px;"><span class="dashicons dashicons-update spin"></span> ZIPファイルを作成しています...</div>');
        
        $.post(sssDev.ajaxUrl, {
            action: 'sss_create_release',
            nonce: sssDev.nonce
        }, function(response) {
            $btn.prop('disabled', false).html('<span class="dashicons dashicons-upload" style="margin-top: 5px;"></span> リリースを作成');
            
            if (response.success) {
                $status.html(
                    '<div style="padding: 15px; background: #d4edda; border-left: 4px solid #28a745; margin-top: 15px;">' +
                    '<strong>✓ ' + response.data.message + '</strong><br>' +
                    '<small>サイズ: ' + response.data.zip_size + '</small><br>' +
                    '<a href="' + response.data.zip_url + '" class="button button-small" style="margin-top: 10px;" download>ZIPをダウンロード</a>' +
                    '</div>'
                );
                
                // 3秒後にページをリロード
                setTimeout(function() {
                    location.reload();
                }, 3000);
            } else {
                $status.html(
                    '<div style="padding: 15px; background: #f8d7da; border-left: 4px solid #dc3545; margin-top: 15px;">' +
                    '<strong>✗ エラー:</strong> ' + response.data +
                    '</div>'
                );
            }
        }).fail(function() {
            $btn.prop('disabled', false).html('<span class="dashicons dashicons-upload" style="margin-top: 5px;"></span> リリースを作成');
            $status.html(
                '<div style="padding: 15px; background: #f8d7da; border-left: 4px solid #dc3545; margin-top: 15px;">' +
                '<strong>✗ 通信エラーが発生しました</strong>' +
                '</div>'
            );
        });
    });

    // エラー通知テストボタン
    $('#sss-test-error-report').on('click', function() {
        var $btn = $(this);
        var originalHtml = $btn.html();
        
        if (!confirm('エラー通知の送信テストを実行します。\n配布サイトの debug.log にログが記録されるか確認してください。\n実行しますか？')) {
            return;
        }
        
        $btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin" style="margin-top: 5px;"></span> 送信中...');
        
        $.post(sssDev.ajaxUrl, {
            action: 'sss_test_error_report',
            nonce: sssDev.nonce
        }, function(response) {
            $btn.prop('disabled', false).html(originalHtml);
            if (response.success) {
                alert('✓ ' + response.data);
            } else {
                alert('✗ エラー: ' + response.data);
            }
        }).fail(function() {
            $btn.prop('disabled', false).html(originalHtml);
            alert('✗ 通信エラーが発生しました');
        });
    });
    
    // スピンアニメーション用CSS追加
    $('<style>.spin { animation: spin 1s linear infinite; } @keyframes spin { 100% { transform: rotate(360deg); } }</style>').appendTo('head');
});
